<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Procedure extends Model 
{

    protected $table = 'procedures';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('libelle', 'description', 'submission_form_url', 'dossier_state_url', 'status');

    public function typeProfils()
    {
        return $this->belongsToMany('App\Models\TypeProfil');
    }

    public function favorites()
    {
        return $this->hasMany('App\Models\Favorite');
    }

}